/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.hooks.ZoomHook;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityRendererHook {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean zoomToggled = false;
    private static boolean isBeingHeld = false;
    private static float oldSensitivity;
    private static float partialTicks;
    public static float lastZoomModifier;

    public static void fixMissingChunks() {
        EntityRendererHook.mc.field_71438_f.func_174979_m();
    }

    public static boolean getZoomState(boolean zoomKeyDown) {
        if (zoomKeyDown) {
            if (isBeingHeld) {
                return zoomToggled;
            }
            isBeingHeld = true;
            zoomToggled = !zoomToggled;
        } else {
            isBeingHeld = false;
        }
        return zoomToggled;
    }

    public static boolean hasMap() {
        if (!PatcherConfig.mapBobbing || EntityRendererHook.mc.field_71439_g == null) {
            return false;
        }
        ItemStack mainHandItem = EntityRendererHook.mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = EntityRendererHook.mc.field_71439_g.func_184592_cb();
        return mainHandItem != null && mainHandItem.func_77973_b() instanceof ItemMap || offHandItem != null && offHandItem.func_77973_b() instanceof ItemMap;
    }

    public static void reduceSensitivityWhenZoomStarts() {
        oldSensitivity = EntityRendererHook.mc.field_71474_y.field_74341_c;
        EntityRendererHook.mc.field_71474_y.field_74341_c = oldSensitivity * PatcherConfig.customZoomSensitivity;
    }

    public static void reduceSensitivityDynamically(float modifier) {
        if (!PatcherConfig.dynamicZoomSensitivity || !ZoomHook.zoomed) {
            return;
        }
        float sensitivity = oldSensitivity * PatcherConfig.customZoomSensitivity;
        EntityRendererHook.mc.field_71474_y.field_74341_c = sensitivity *= modifier / lastZoomModifier;
    }

    public static void resetSensitivity() {
        EntityRendererHook.mc.field_71474_y.field_74341_c = oldSensitivity;
    }

    public static float getHandFOVModifier(float original) {
        if (PatcherConfig.renderHandWhenZoomed && (ZoomHook.zoomed || PatcherConfig.smoothZoomAnimation && ZoomHook.smoothZoomProgress > 0.0f)) {
            float f = 70.0f;
            IBlockState block = ActiveRenderInfo.func_186703_a((World)EntityRendererHook.mc.field_71441_e, (Entity)EntityRendererHook.mc.field_71439_g, (float)partialTicks);
            if (block.func_185904_a() == Material.field_151586_h) {
                f = f * 60.0f / 70.0f;
            }
            return f;
        }
        return original;
    }

    @SubscribeEvent
    public void worldRender(RenderWorldLastEvent event) {
        partialTicks = event.getPartialTicks();
    }
}

